/*

-- Edit Functions Script File
--
-- Created:  		May 17 2000
--
-- Version:  3D Studio Max Version 6.0
--
-- 

Revision History

	Mai 26th 2003, pfb
               added in 3ds MAX 6
        Jan 30th 2003, pfb
		added product id check for VIZR:  hardcoded to meters
		
	Sept 4th 2001, pfb
	Added InchesToSystemScale function

	main usage: 
		allowing creation of objects based on the current system units, in order to always be in 'normal world' scale
		for example, a fluorescent panel is usually 4ft long, no matter if the system units are in cm, miles or inches.
*/

 
-- Filter and Operation Functions for conext sensitve menus.
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- 


fn ApplyOperation ctype oper =
(
	If (Modpanel.getcurrentObject () == $.baseobject) then oper $
	If Classof (Modpanel.getcurrentObject ()) == ctype then (oper $.modifiers[modPanel.getModifierIndex $ (Modpanel.getcurrentObject ())])	
)

-------------------------------------------------------------------------------------
-- Sept 4th 2001, pfb
-- Added Functions for VIZ R4
-------------------------------------------------------------------------------------


-- pass an inch value and returns corresponding value based on the system units
-- it is called by the 'Preset Lights' macros in the Macro_ObjectsLights.mcr file and by the mentalray scripted lights

fn InchesToSystemScale val=
(		
	case units.systemtype of
	(
		#inches:val = val
		#feet:val = 0.08333333333333333 * val
		#miles:val = 0.000015782828282828283 * val
		
		#millimeters:val = 25.4 * val
		#centimeters:val = 2.54 * val
		#meters:val = 0.0254 * val
		#kilometers:val = 0.000025399999999999997 * val
	)

	val
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCQjkKekY8IfmSLlAuOWJj7NC8srKabxh7q
-- c2ARhMQRH9MaU/54Ofd7v9J9kalH4Lkw5D3wBKRj5v5AKO9RjkqjxB2OvEbab3tC
-- 5xCbKfOGYMaQwqRUfZqclndiNafffLBu7HX952LpbYYNldnMw4TsFAKKZ+FikE5K
-- QayS8taxN2UPLfIrdYWNfm+UpplJ07nUkEKMucZZB8MSJDFmq//9pV8cLXz/94HO
-- 9b0TwFYin6yXnBV/XQ5jntACJkjN5d3MU668TujrvAzqoutcmnAxFLB9ff/vB1tD
-- rk67SCcu29bqLCiJkcTJXMN3qBctI6HKfUQZR4YOTds6lsvfg8Hc
-- -----END-SIGNATURE-----